ORCA/M Asm65816 2.1.0

0001 BC03                       title 'StatTextProc' 
0002 BC03              **********************************************************************
0003 BC03              *
0004 BC03              * Static Text Control Def Proc
0005 BC03              *
0006 BC03              *
0007 BC03              * Copyright (C)
0008 BC03              * Apple Computer, Inc.  1986-1989
0009 BC03              * All Rights Reserved
0010 BC03              *
0011 BC03              * 23 Sep 88         Steven Glass
0012 BC03              *
0013 BC03              * Coding began from modified version of Tech Support's custom
0014 BC03              * control (by Keith Rollin).
0015 BC03              *
0016 BC03              * 10 Oct 88         Steven Glass
0017 BC03              *
0018 BC03              * Made memory allocation work correctly for the four cases: ptr, handle
0019 BC03              * resource and offset.  Got drawing to work correctly for offset.
0020 BC03              * Removed code that looked for errors from resource loads.  Locked
0021 BC03              * and unlocked control handle around calls to LETextBox2 when text
0022 BC03              * is in the control record.
0023 BC03              *
0024 BC03              * 23 Nov 88         Steven Glass
0025 BC03              *
0026 BC03              * Removed code that supports offsets.
0027 BC03              *
0028 BC03              * 06 Feb 89         Steven Glass
0029 BC03              *
0030 BC03              * Added support for initial justification being other than 0.
0031 BC03              * Changed drawing routine to deref the control handle after 
0032 BC03              * compiling text and drawing text.
0033 BC03              *
0034 BC03              * 22 Mar 89         Harry Yee
0035 BC03              *
0036 BC03              * Control handle was not being derefed enough times possibly allowing memory to move 
0037 BC03              * and making pointer no longer valid. In routine ConvertRefToPtr added additional deref
0038 BC03              * after GetHandleSize call.
0039 BC03              *
0040 BC03              * 28 Mar 89         Steven Glass
0041 BC03              *
0042 BC03              * Added support for the ctlWinStateChange message.  Message is ignored
0043 BC03              * since this control does not look any different if it is in an active vs
0044 BC03              * inactive window.
0045 BC03              *
0046 BC03              * 09 Apr 89         Harry Yee
0047 BC03              *
0048 BC03              * The 22 Mar 89 fix above didn't fix the bug. Problem was LETextBox2 moves memory!
0049 BC03              * Since the control handle is unlocked, the ptr to the control rect passed to
0050 BC03              * LETextBox2 could possibly become invalid after the first NewHandle call in 
0051 BC03              * LETextBox2. We now make sure we lock the control's handle. BRC #46453.
0052 BC03              *
0053 BC03              * 4/13/89           Mensch
0054 BC03              *
0055 BC03              * The apr 09 fix caused a strange bug when the defproc is called for the rec size,
0056 BC03              * it tries to unlock the control handle, but fails since the control handle
0057 BC03              * does not exist, here. Now we will branch around the unlock if the ctrlcode
0058 BC03              * is 6
0059 BC03              *
0060 BC03              * 8/31/89           Yee
0061 BC03              *
0062 BC03              * Changed the name of routine do_init to do_StatInit. This is to avoid conflict
0063 BC03              * between other defprocs using this same name. 
0064 BC03              * Fix bug in INIT routine where the justification field from the template 
0065 BC03              * is not being copied over to the control record. BRC #51450.
0066 BC03              *
0067 BC03              **********************************************************************
0068 BC03
0069 BC03                       blanks off 
0070 BC03                       string asis 
0071 BC03
0072 BC03                       print push 
0073 BC03                       print off 
0074 BC03
0075 BC03                       include 'all.macros' 
0076 BC03
0077 BC03                       include 'CtlCustomEqus.asm' 
0078 BC03                       include 'e16.quickdraw' 
0079 BC03                       include 'e16.resources' 
0080 BC03
0081 BC03              ;-----------------------------------------------------------
0082 BC03              ;
0083 BC03              ; Stack Fram Equates for control
0084 BC03              ;
0085 BC03                       DefineStack 
0086 BC03              OrigD    WORD                           ; caller's saved direct page register
0087 BC03              OrigB    byte                           ; caller's saved data bank register
0088 BC03              CtlPtr   LONG                           ; pointer to control record
0089 BC03              RtnAddr  block 3                        ; RTL address back to Control Manager
0090 BC03              theCtlHandle LONG                       ; handle to control record
0091 BC03              CtlParam LONG                           ; add'l parameter passed to DefProc
0092 BC03              CtlCode  WORD                           ; operation to perform
0093 BC03              ReturnValue LONG                        ; space for return value to Ctl Mgr.
0094 BC03
0095 BC03
0096 BC03                       print pop 
0097 BC03
0098 BC03
0099 BC03                       title 'StatTextProc -- Main Entry' 
0100 BC03              ****************************************************************
0101 BC03              *
0102 BC03              StatTextProc PROC EXPORT 
0103 BC03              *
0104 BC03              * This is the def_proc for static text.  When this
0105 BC03              * routine gets control, the stack looks as described below.
0106 BC03              *
0107 BC03              *
0108 BC03              *
0109 BC03              * Inputs:           On entry, the parameters are passed to us on the stack.
0110 BC03              *
0111 BC03              *                   |                   | Previous Contents
0112 BC03              *                   |-------------------|
0113 BC03              *                   |    ReturnValue    | LONG - Space for return value
0114 BC03              *                   |-------------------|
0115 BC03              *                   |    CtlCode        | WORD - operation to perform
0116 BC03              *                   |-------------------|
0117 BC03              *                   |    CtlParam       | LONG - add'l parameter
0118 BC03              *                   |-------------------|
0119 BC03              *                   |    theCtlHandle   | LONG - Handle to control record
0120 BC03              *                   |-------------------|
0121 BC03              *                   |    RtnAddr        | 3 BYTES - RTL address
0122 BC03              *                   |-------------------|
0123 BC03              *                   |                   | <-- Stack pointer
0124 BC03              *
0125 BC03              * Outputs:          Put something into ReturnValue, pull off the parameters,
0126 BC03              *                   and return to the Control Manager.
0127 BC03              *
0128 BC03              *                   |                   | Previous Contents
0129 BC03              *                   |-------------------|
0130 BC03              *                   |    ReturnValue    | LONG - Space for return value
0131 BC03              *                   |-------------------|
0132 BC03              *                   |    RtnAddr        | 3 BYTES - RTL address
0133 BC03              *                   |-------------------|
0134 BC03              *                   |                   | <-- Stack pointer
0135 BC03              *
0136 BC03              * External Refs:
0137 BC03                       import do_draw 
0138 BC03                       import do_nothing 
0139 BC03                       import do_test 
0140 BC03                       import do_dispose 
0141 BC03                       import do_StatInit 
0142 BC03                       import do_recsize 
0143 BC03                       import do_ChangeState 
0144 BC03              *
0145 BC03              * Entry Points:
0146 BC03              *                   none
0147 BC03              *
0148 BC03                       longa on                       ; mode
0149 BC03                       longi on
0150 BC03              *
0151 BC03              ****************************************************************
0152 BC03
0153 BC03 48                    pha                            ; push on some room for 'CtlPtr'
0154 BC04 48                    pha   
0155 BC05
0156 BC05 8B                    phb                            ; save the Data Bank register
0157 BC06 0B                    phd                            ; save the Direct Page register
0158 BC07
0159 BC07 4B                    phk                            ; switch data bank to program bank
0160 BC08 AB                    plb   
0161 BC09 3B                    tsc                            ; switch Direct Page into stack
0162 BC0A 5B                    tcd   
0163 BC0B
0164 BC0B A5 13                 lda   <CtlCode
0165 BC0D C9 0C 00              cmp   #recSize
0166 BC10 F0 15                 beq   SkipDeref
0167 BC12
0168 BC12 A0 04 00              ldy   #4                       ; first lock down the control handle
0169 BC15 B7 0B                 lda   [<theCtlHandle],y
0170 BC17 09 00 80              ora   #$8000
0171 BC1A 97 0B                 sta   [<theCtlHandle],y
0172 BC1C
0173 BC1C A7 0B                 lda   [<theCtlHandle]          ; now deref the control handle
0174 BC1E 85 04                 sta   <CtlPtr
0175 BC20 A0 02 00              ldy   #2
0176 BC23 B7 0B                 lda   [<theCtlHandle],y
0177 BC25 85 06                 sta   <CtlPtr+2
0178 BC27
0179 BC27              SkipDeref  
0180 BC27 A5 13                 lda   <CtlCode                 ; get routine # to call
0181 BC29 C9 14 00              cmp   #ctlWinStateChange+1     ; make sure the msg is in range.
0182 BC2C 90 03                 blt   ShiftIt
0183 BC2E A9 06 00              lda   #6                       ; force unknown codes to null events
0184 BC31              ShiftIt   
0185 BC31 0A                    asl   a
0186 BC32 AA                    tax   
0187 BC33 FC 5C BC              jsr   (ActionTable,x)
0188 BC36
0189 BC36 85 15                 sta   <ReturnValue             ; save the return value
0190 BC38 86 17                 stx   <ReturnValue+2
0191 BC3A
0192 BC3A              ;
0193 BC3A              ; 4/13/89 fixed this to only unlock if the handle was locked!
0194 BC3A A5 13                 lda   <CtlCode
0195 BC3C C9 0C 00              cmp   #recSize
0196 BC3F F0 0A                 beq   SkipUnLock
0197 BC41
0198 BC41 A0 04 00              ldy   #4                       ; unlock the control handle
0199 BC44 B7 0B                 lda   [<theCtlHandle],y
0200 BC46 29 FF 7F              and   #$7FFF
0201 BC49 97 0B                 sta   [<theCtlHandle],y
0202 BC4B              SkipUnLock  
0203 BC4B              ; ENDOFFIX
0204 BC4B
0205 BC4B              ;
0206 BC4B              ; The Return Value has been stored on the stack, and it is time for us to
0207 BC4B              ; return back to the Control Manager. Before we do so, however, we must
0208 BC4B              ; remove the parameters that were passed to us on the stack. We do this
0209 BC4B              ; by moving the RTL address up just below the Return Value, getting the
0210 BC4B              ; stack pointer, and adding an amount to it so that we point to where
0211 BC4B              ; the RTL address has been moved to. We can then simply RTL back to the
0212 BC4B              ; Control Manager, and it will pick up the Return Value right off of the
0213 BC4B              ; stack!
0214 BC4B              ;
0215 BC4B A5 08                 lda   <RtnAddr                 ; move the return address up
0216 BC4D 85 12                 sta   <ReturnValue-3
0217 BC4F A5 09                 lda   <RtnAddr+1
0218 BC51 85 13                 sta   <ReturnValue-2
0219 BC53
0220 BC53 3B                    tsc                            ; Get the stack pointer
0221 BC54
0222 BC54 2B                    pld                            ; restore caller's Data Bank and
0223 BC55 AB                    plb                            ; Direct Page registers
0224 BC56
0225 BC56 18                    clc                            ; Adjust the stack pointer to point to
0226 BC57 69 11 00              adc   #ReturnValue-4           ; the new location of the RTL address.
0227 BC5A 1B                    tcs                            ; Put the stack pointer back.
0228 BC5B
0229 BC5B 6B                    rtl                            ; back to the caller
0230 BC5C
0231 BC5C
0232 BC5C              ;
0233 BC5C 07 BD        ActionTable DC W:do_draw                0 Draw simple button.
0234 BC5E 8B BC                 DC W:do_nothing                1 Compute drag RECT.
0235 BC60 EC BC                 DC W:do_test                   2 Common hit test routine.
0236 BC62 A8 BC                 DC W:do_StatInit               3 Initialize the control.
0237 BC64 90 BC                 DC W:do_dispose                4 Dispose.
0238 BC66 07 BD                 DC W:do_draw                   5 New value.
0239 BC68 8B BC                 DC W:do_nothing                6 Compute Thumber constrains.
0240 BC6A 8B BC                 DC W:do_nothing                7 Drag the indicator.
0241 BC6C 8B BC                 DC W:do_nothing                8 Auto action.
0242 BC6E 07 BD                 DC W:do_draw                   9 New value.
0243 BC70 8B BC                 DC W:do_nothing                10 Set min max.
0244 BC72 8B BC                 DC W:do_nothing                11 Move button.
0245 BC74 84 BC                 DC W:do_recsize                12 Return size of standard record.
0246 BC76 8B BC                 DC W:do_nothing                13 take key or menu event
0247 BC78 8B BC                 DC W:do_nothing                14 ctlChangeTarget
0248 BC7A 8B BC                 DC W:do_nothing                15 ctlChagneBounds
0249 BC7C 8B BC                 DC W:do_nothing                16 ctlWindChagneSize
0250 BC7E 8B BC                 DC W:do_nothing                17 ctlHandleTab
0251 BC80 8B BC                 DC W:do_nothing                18 ctlNotifyMultiPart
0252 BC82 8B BC                 DC W:do_nothing                19 ctlWinStateChange
0253 BC84
0254 BC84                       ENDP 
0255 BC84
0256 BC84                       title 'StatTextProc -- do_recsize' 
0257 BC84              ****************************************************************
0258 BC84              *
0259 BC84              do_recsize PROC 
0260 BC84              *
0261 BC84              * Returns the size of the control record.  This is the
0262 BC84              * normal size of a new control record.  
0263 BC84              *
0264 BC84              * Note that the high word will always be 0.
0265 BC84              *
0266 BC84              *
0267 BC84              * Inputs:
0268 BC84              *                   none
0269 BC84              *
0270 BC84              * Outputs:
0271 BC84              *                   a-reg & x-reg hold result for def proc
0272 BC84              *
0273 BC84              * External Refs:
0274 BC84              *                   none
0275 BC84              *
0276 BC84              * Entry Points:
0277 BC84              *                   none
0278 BC84              *
0279 BC84                       longa on                       ; mode
0280 BC84                       longi on
0281 BC84              *
0282 BC84              ****************************************************************
0283 BC84
0284 BC84 A9 40 00              lda   #superCtlSize
0285 BC87 A2 00 00              ldx   #0                       High word of size.
0286 BC8A
0287 BC8A 60                    rts   
0288 BC8B
0289 BC8B                       ENDP 
0290 BC8B
0291 BC8B                       title 'StatTextProc -- do_nothing' 
0292 BC8B              ****************************************************************
0293 BC8B              *
0294 BC8B              do_nothing PROC 
0295 BC8B              *
0296 BC8B              * This is the routine we use when there is nothing to do.
0297 BC8B              * It just returns zeros in the a and x registers.
0298 BC8B              *
0299 BC8B              *
0300 BC8B              * Inputs:
0301 BC8B              *                   ctlHandle
0302 BC8B              *                   ctlPtr
0303 BC8B              *
0304 BC8B              * Outputs:
0305 BC8B              *                   a-reg & x-reg hold result for def proc
0306 BC8B              *
0307 BC8B              * External Refs:
0308 BC8B              *                   none
0309 BC8B              *
0310 BC8B              * Entry Points:
0311 BC8B              *                   none
0312 BC8B              *
0313 BC8B                       longa on                       ; mode
0314 BC8B                       longi on
0315 BC8B              *
0316 BC8B              ****************************************************************
0317 BC8B
0318 BC8B              ;
0319 BC8B A9 00 00              lda   #0                       Nothing flag.
0320 BC8E AA                    tax   
0321 BC8F
0322 BC8F 60                    rts   
0323 BC90
0324 BC90                       ENDP 
0325 BC90
0326 BC90                       title 'StatTextProc -- do_dispose' 
0327 BC90              ****************************************************************
0328 BC90              *
0329 BC90              do_dispose PROC  
0330 BC90              *
0331 BC90              * This is the routine we use when the control is disposed.
0332 BC90              * The only thing this routine has to do is to release the 
0333 BC90              * resource if the text is referenced by resource.
0334 BC90              *
0335 BC90              *
0336 BC90              * Inputs:
0337 BC90              *                   ctlHandle
0338 BC90              *                   ctlPtr
0339 BC90              *
0340 BC90              * Outputs:
0341 BC90              *                   a-reg & x-reg hold result for def proc
0342 BC90              *
0343 BC90              * External Refs:
0344 BC90                       import CtlDataToAX 
0345 BC90                       import GetRefType 
0346 BC90              *
0347 BC90              * Entry Points:
0348 BC90              *                   none
0349 BC90              *
0350 BC90                       longa on                       ; mode
0351 BC90                       longi on
0352 BC90              *
0353 BC90              ****************************************************************
0354 BC90
0355 BC90 20 67 BE              jsr   GetRefType
0356 BC93
0357 BC93 C9 02 00              cmp   #$0002
0358 BC96 D0 0B                 bne   NotResource
0359 BC98
0360 BC98 F4 0B 80              PushWord #rTextForLETextBox2   ; type
0361 BC9B 20 5C BE              jsr   CtlDataToAX
0362 BC9E DA                    phx   
0363 BC9F 48                    pha   
0364 BCA0 20 90 9E              jsr   ReleaseResource
0365 BCA3
0366 BCA3              NotResource  
0367 BCA3              ;
0368 BCA3 A9 00 00              lda   #0                       Nothing flag.
0369 BCA6 AA                    tax   
0370 BCA7
0371 BCA7 60                    rts   
0372 BCA8
0373 BCA8                       ENDP 
0374 BCA8
0375 BCA8                       title 'StatTextProc -- do_StatInit' 
0376 BCA8              ****************************************************************
0377 BCA8              *
0378 BCA8              do_StatInit PROC EXPORT 
0379 BCA8              *
0380 BCA8              * Inits the data and value fields in the control record
0381 BCA8              * using values in the template.
0382 BCA8              *
0383 BCA8              * Also looks for the ctlJust field if the pCount is at least 9.
0384 BCA8              *
0385 BCA8              * The ctlData field is set to be a reference to the static text
0386 BCA8              * and the ctlValue field is set to be the size of the static
0387 BCA8              * text field (if the ref is a pointer).
0388 BCA8              *
0389 BCA8              *
0390 BCA8              * Inputs:
0391 BCA8              *                   ctlHandle
0392 BCA8              *                   ctlPtr
0393 BCA8              *                   ctlParam = ptr to template
0394 BCA8              *
0395 BCA8              * Outputs:
0396 BCA8              *                   a-reg and x-reg are zero.
0397 BCA8              *
0398 BCA8              * External Refs:
0399 BCA8                       import GetRefType 
0400 BCA8              *
0401 BCA8              * Entry Points:
0402 BCA8              *                   none
0403 BCA8              *
0404 BCA8                       longa on                       ; mode
0405 BCA8                       longi on
0406 BCA8              *
0407 BCA8              * Change History
0408 BCA8              *
0409 BCA8              * 06 Feb 89         Steven Glass
0410 BCA8              *
0411 BCA8              * Added support for the optional justification field in the
0412 BCA8              * template.
0413 BCA8              *
0414 BCA8              ****************************************************************
0415 BCA8
0416 BCA8 20 67 BE              jsr   GetRefType               ; low 2 bits of flag in a-reg
0417 BCAB C9 00 00              cmp   #0
0418 BCAE D0 0A                 bne   NotAPtr
0419 BCB0
0420 BCB0 A0 1E 00              ldy   #StatTextTemplate.TextSize
0421 BCB3 B7 0F                 lda   [<ctlParam],y
0422 BCB5 A0 12 00              ldy   #NewCtlRecord.ctlValue
0423 BCB8 97 04                 sta   [<ctlPtr],y
0424 BCBA
0425 BCBA              NotAPtr   
0426 BCBA A0 1A 00              ldy   #StatTextTemplate.TextRef
0427 BCBD B7 0F                 lda   [<ctlParam],y
0428 BCBF AA                    tax   
0429 BCC0 C8                    iny   
0430 BCC1 C8                    iny   
0431 BCC2 B7 0F                 lda   [<ctlParam],y
0432 BCC4
0433 BCC4 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0434 BCC7 97 04                 sta   [<ctlPtr],y
0435 BCC9 88                    dey   
0436 BCCA 88                    dey   
0437 BCCB 8A                    txa   
0438 BCCC 97 04                 sta   [<ctlPtr],y
0439 BCCE
0440 BCCE
0441 BCCE A0 28 00              ldy   #NewCtlRecord.CtlJust    ; init the just word
0442 BCD1 A9 00 00              lda   #0
0443 BCD4 97 04                 sta   [<ctlPtr],y
0444 BCD6 BB                    tyx                            ; save offset in x
0445 BCD7
0446 BCD7 A0 00 00              ldy   #StatTextTemplate.pCount ; check the p count
0447 BCDA                       lda   [<ctlParam],y
0448 BCDA C9 09 00              cmp   #9
0449 BCDD 90 08                 bcc   Fini
0450 BCDF
0451 BCDF A0 20 00              ldy   #StatTextTemplate.Just   ; move the real value
0452 BCE2 B7 0F                 lda   [<ctlParam],y            ; into place
0453 BCE4 9B                    txy                            ; using saved offset.
0454 BCE5 97 04                 sta   [<ctlPtr],y
0455 BCE7
0456 BCE7              Fini      
0457 BCE7 A9 00 00              lda   #0
0458 BCEA AA                    tax   
0459 BCEB 60                    rts   
0460 BCEC
0461 BCEC
0462 BCEC
0463 BCEC                       ENDP 
0464 BCEC
0465 BCEC                       title 'StatTextProc -- do_test' 
0466 BCEC              ****************************************************************
0467 BCEC              *
0468 BCEC              do_test  PROC 
0469 BCEC              *
0470 BCEC              * Test if the mouse is down in the control.  We always
0471 BCEC              * return no, since it does not make sense to "click" on
0472 BCEC              * static text.
0473 BCEC              *
0474 BCEC              *
0475 BCEC              * Inputs:
0476 BCEC              *                   ctlParam = point to check
0477 BCEC              *
0478 BCEC              *
0479 BCEC              * Outputs:
0480 BCEC              *                   a-reg and x-reg are always zero
0481 BCEC              *
0482 BCEC              * External Refs:
0483 BCEC              *                   none
0484 BCEC              *
0485 BCEC              * Entry Points:
0486 BCEC              *                   none
0487 BCEC              *
0488 BCEC                       longa on                       ; mode
0489 BCEC                       longi on
0490 BCEC              *
0491 BCEC              ****************************************************************
0492 BCEC
0493 BCEC A0 11 00              ldy   #NewCtlRecord.ctlHilite
0494 BCEF B7 04                 lda   [ctlPtr],y
0495 BCF1 29 FF 00              and   #$00FF
0496 BCF4 C9 FF 00              cmp   #$00FF
0497 BCF7 F0 07                 beq   Inactive
0498 BCF9
0499 BCF9 A9 01 00              lda   #1
0500 BCFC A2 00 00              ldx   #0
0501 BCFF 60                    rts   
0502 BD00
0503 BD00
0504 BD00              Inactive  
0505 BD00 A9 00 00              lda   #0
0506 BD03 A2 00 00              ldx   #0
0507 BD06
0508 BD06 60                    rts   
0509 BD07
0510 BD07                       ENDP 
0511 BD07
0512 BD07                       title 'StatTextProc -- do_draw' 
0513 BD07              ****************************************************************
0514 BD07              *
0515 BD07              do_draw  PROC 
0516 BD07              *
0517 BD07              * Draws the control using LETextBox2.  The control is only
0518 BD07              * drawn if the part code being passed is 0, indicating the
0519 BD07              * whole control.
0520 BD07              *
0521 BD07              *
0522 BD07              * Inputs:
0523 BD07              *                   ctlHandle
0524 BD07              *                   ctlPtr
0525 BD07              *
0526 BD07              * Outputs:
0527 BD07              *                   a-reg and x-reg are zero.
0528 BD07              *
0529 BD07              * External Refs:
0530 BD07                       import CtlDataToAX 
0531 BD07                       import GetRefType 
0532 BD07              *
0533 BD07              * Entry Points:
0534 BD07              *                   none
0535 BD07              *
0536 BD07                       longa on                       ; mode
0537 BD07                       longi on
0538 BD07              *
0539 BD07              *
0540 BD07              * Change History
0541 BD07              *
0542 BD07              * 06 Feb 89         Steven Glass
0543 BD07              *
0544 BD07              * The control handle was not being re-derefed twice where 
0545 BD07              * memory could have moved:   once after compiling text and
0546 BD07              * once after drawing the text.
0547 BD07              *
0548 BD07              * Added new feature to drawing: the programmer can set
0549 BD07              * a value for the initial justification.  This value is 
0550 BD07              * kept in the ctlJust field of the control record.
0551 BD07              *
0552 BD07              ****************************************************************
0553 BD07
0554 BD07              ;-----------------------------------------------------------
0555 BD07              ;
0556 BD07              ; Look at the part code.  If it is not 0, this is a request
0557 BD07              ; to hilite the control (which we ignore).
0558 BD07              ;
0559 BD07 A5 0F                 lda   ctlParam
0560 BD09 F0 03                 beq   @cont
0561 BD0B 82 E6 00              brl   Fini
0562 BD0E
0563 BD0E              @cont     
0564 BD0E
0565 BD0E              ;-----------------------------------------------------------
0566 BD0E              ;
0567 BD0E              ; See if we need to do substitution on the text.
0568 BD0E              ;
0569 BD0E
0570 BD0E A0 10 00              ldy   #NewCtlRecord.ctlFlag
0571 BD11 B7 04                 lda   [ctlPtr],y
0572 BD13 29 02 00              and   #FSubstituteText
0573 BD16 D0 03                 bne   MakeSubs
0574 BD18
0575 BD18 82 82 00              brl   NoSubs
0576 BD1B
0577 BD1B              MakeSubs  
0578 BD1B
0579 BD1B              ; TextHandle := CompileText (SubType, SubArrayPtr, OrigTextPtr, OrigTextSize)
0580 BD1B
0581 BD1B 48                    pha                            ; space for handle
0582 BD1C 48                    pha   
0583 BD1D B7 04                 lda   [ctlPtr],y               ; type of text
0584 BD1F 29 01 00              and   #FSubTextType
0585 BD22 48                    pha   
0586 BD23 48                    pha                            ; pointer to sub array
0587 BD24 48                    pha   
0588 BD25 A2 10 35 22           _GetCtlParamPtr 
0589 BD2C 48                    pha                            ; pointer to text
0590 BD2D 48                    pha   
0591 BD2E
0592 BD2E 20 67 BE              jsr   GetRefType
0593 BD31 48                    pha   
0594 BD32 20 5C BE              jsr   CtlDataToAX
0595 BD35 DA                    phx   
0596 BD36 48                    pha   
0597 BD37 20 F9 BD              jsr   ConvertRefToPtr
0598 BD3A A0 12 00              ldy   #NewCtlRecord.ctlValue   ; text length
0599 BD3D B7 04                 lda   [<CtlPtr],y
0600 BD3F 48                    pha   
0601 BD40 A2 0E 60 22           _CompileText 
0602 BD47 68 85 0F 68           PullLong CtlParam              ; Put resulting handle into CtlParam
0603 BD4D
0604 BD4D 48                    pha                            ; Get handle's size.
0605 BD4E 48                    pha   
0606 BD4F D4 11                 pei   CtlParam+2
0607 BD51 D4 0F                 pei   Ctlparam
0608 BD53 A2 02 18 22           _GetHandleSize 
0609 BD5A
0610 BD5A 68                    pla                            ; get size of handle off the stack
0611 BD5B FA                    plx   
0612 BD5C 48                    pha                            ; put it on the stack 3 times
0613 BD5D 48                    pha   
0614 BD5E 48                    pha   
0615 BD5F
0616 BD5F              ; Three copies of text size now on stack.  First two will be over written by
0617 BD5F              ; Pointer to text.
0618 BD5F
0619 BD5F A0 04 00              ldy   #4                       ; lock compiled text
0620 BD62 B7 0F                 lda   [ctlParam],y
0621 BD64 09 00 80              ora   #$8000
0622 BD67 97 0F                 sta   [ctlParam],y
0623 BD69 88                    dey   
0624 BD6A 88                    dey   
0625 BD6B B7 0F                 lda   [ctlParam],y
0626 BD6D AA                    tax   
0627 BD6E A7 0F                 lda   [ctlParam]
0628 BD70 83 03                 sta   3,s                      ; Handle^ goes on stack above size word
0629 BD72 8A                    txa   
0630 BD73 83 05                 sta   5,s
0631 BD75
0632 BD75 A5 04                 lda   <CtlPtr                  ; rect pointer
0633 BD77 18                    clc   
0634 BD78 69 08 00              adc   #NewCtlRecord.ctlRect
0635 BD7B AA                    tax   
0636 BD7C A5 06                 lda   <CtlPtr+2
0637 BD7E 69 00 00              adc   #0
0638 BD81 48                    pha   
0639 BD82 DA                    phx   
0640 BD83
0641 BD83 A0 28 00              ldy   #NewCtlRecord.CtlJust
0642 BD86 B7 04                 lda   [<CtlPtr],y
0643 BD88 48                    pha   
0644 BD89 A2 14 20 22           _LETextBox2 
0645 BD90
0646 BD90 D4 11                 pei   CtlParam+2
0647 BD92 D4 0F                 pei   CtlParam
0648 BD94 A2 02 10 22           _DisposeHandle 
0649 BD9B
0650 BD9B 80 2F                 bra   CleanUp
0651 BD9D
0652 BD9D              NoSubs    
0653 BD9D              ;-----------------------------------------------------------
0654 BD9D              ;
0655 BD9D              ; LeTextBox2 (TextPtr,TextSize,RectPtr,LeftJust)
0656 BD9D              ;
0657 BD9D 48                    pha   
0658 BD9E 48                    pha                            ; space for result
0659 BD9F
0660 BD9F 20 67 BE              jsr   GetRefType
0661 BDA2 48                    pha   
0662 BDA3 20 5C BE              jsr   CtlDataToAX
0663 BDA6 DA                    phx   
0664 BDA7 48                    pha   
0665 BDA8 20 F9 BD              jsr   ConvertRefToPtr
0666 BDAB
0667 BDAB A0 12 00              ldy   #NewCtlRecord.ctlValue   ; text length
0668 BDAE B7 04                 lda   [<CtlPtr],y
0669 BDB0 48                    pha   
0670 BDB1
0671 BDB1 A5 04                 lda   <CtlPtr                  ; rect pointer
0672 BDB3 18                    clc   
0673 BDB4 69 08 00              adc   #NewCtlRecord.ctlRect
0674 BDB7 AA                    tax   
0675 BDB8 A5 06                 lda   <CtlPtr+2
0676 BDBA 69 00 00              adc   #0
0677 BDBD 48                    pha   
0678 BDBE DA                    phx   
0679 BDBF
0680 BDBF A0 28 00              ldy   #NewCtlRecord.CtlJust
0681 BDC2 B7 04                 lda   [<CtlPtr],y
0682 BDC4 48                    pha   
0683 BDC5 A2 14 20 22           _LETextBox2 
0684 BDCC
0685 BDCC              ;
0686 BDCC              ; CleanUp -- common exit point for both BlastText and normal
0687 BDCC              ;
0688 BDCC              CleanUp   
0689 BDCC
0690 BDCC              ;-----------------------------------------------------------
0691 BDCC              ;
0692 BDCC              ; Unlock anything we locked coming in.
0693 BDCC              ;
0694 BDCC 20 67 BE              jsr   GetRefType
0695 BDCF AA                    tax   
0696 BDD0 F0 22                 beq   Fini
0697 BDD2
0698 BDD2 C9 01 00              cmp   #$0001
0699 BDD5 F0 08                 beq   @UnlockHandle
0700 BDD7
0701 BDD7 20 5C BE              jsr   CtlDataToAX
0702 BDDA 20 4F BE              jsr   GetResourceHandle
0703 BDDD 80 03                 bra   @UnlockIt
0704 BDDF
0705 BDDF 20 5C BE     @UnlockHandle jsr   CtlDataToAX
0706 BDE2 DA           @UnlockIt phx   
0707 BDE3 48                    pha   
0708 BDE4 0B                    phd   
0709 BDE5 3B                    tsc   
0710 BDE6 5B                    tcd   
0711 BDE7 A0 04 00              ldy   #4
0712 BDEA B7 03                 lda   [3],y
0713 BDEC 29 FF 7F              and   #$7FFF
0714 BDEF 97 03                 sta   [3],y
0715 BDF1 2B                    pld   
0716 BDF2 68                    pla   
0717 BDF3 68                    pla   
0718 BDF4
0719 BDF4              oops      
0720 BDF4              ;-----------------------------------------------------------
0721 BDF4              ;
0722 BDF4              ; Return nothing
0723 BDF4              ;
0724 BDF4 A9 00 00     Fini     lda   #0
0725 BDF7 AA                    tax   
0726 BDF8 60                    rts   
0727 BDF9
0728 BDF9
0729 BDF9
0730 BDF9
0731 BDF9              ConvertRefToPtr  
0732 BDF9                       DefineStack 
0733 BDF9              RTS      word 
0734 BDF9              TheRef   long 
0735 BDF9              TheVerb  word 
0736 BDF9              ThePtr   long 
0737 BDF9
0738 BDF9 A3 07                 lda   TheVerb,s
0739 BDFB 29 03 00              and   #$0003
0740 BDFE F0 45                 beq   @AlreadyPtr
0741 BE00
0742 BE00 C9 01 00              cmp   #1
0743 BE03 F0 0D                 beq   @ItsHandle
0744 BE05
0745 BE05              @ItsResource  
0746 BE05 A3 05                 lda   TheRef+2,s
0747 BE07 AA                    tax   
0748 BE08 A3 03                 lda   TheRef,s
0749 BE0A 20 4F BE              jsr   GetResourceHandle
0750 BE0D 83 03                 sta   TheRef,s
0751 BE0F 8A                    txa   
0752 BE10 83 05                 sta   TheRef+2,s
0753 BE12
0754 BE12 3B           @ItsHandle tsc   
0755 BE13 0B                    phd   
0756 BE14 5B                    tcd   
0757 BE15 A0 04 00              ldy   #4
0758 BE18 B7 03                 lda   [TheRef],y
0759 BE1A 09 00 80              ora   #$8000
0760 BE1D 97 03                 sta   [TheRef],y
0761 BE1F A7 03                 lda   [TheRef]
0762 BE21 85 09                 sta   ThePtr
0763 BE23 88                    dey   
0764 BE24 88                    dey   
0765 BE25 B7 03                 lda   [TheRef],y
0766 BE27 85 0B                 sta   ThePtr+2
0767 BE29
0768 BE29 48                    pha   
0769 BE2A 48                    pha   
0770 BE2B D4 05                 pei   TheRef+2
0771 BE2D D4 03                 pei   TheRef
0772 BE2F A2 02 18 22           _GetHandleSize 
0773 BE36 FA                    plx   
0774 BE37 68                    pla   
0775 BE38
0776 BE38 2B                    pld   
0777 BE39
0778 BE39 A0 12 00              ldy   #NewCtlRecord.ctlValue
0779 BE3C 8A                    txa   
0780 BE3D 97 04                 sta   [<ctlPtr],y
0781 BE3F
0782 BE3F FA           @Strip   plx   
0783 BE40 68                    pla   
0784 BE41 68                    pla   
0785 BE42 68                    pla   
0786 BE43 DA                    phx   
0787 BE44 60                    rts   
0788 BE45
0789 BE45
0790 BE45
0791 BE45              @AlreadyPtr  
0792 BE45 A3 03                 lda   TheRef,s
0793 BE47 83 09                 sta   ThePtr,s
0794 BE49 A3 05                 lda   TheRef+2,s
0795 BE4B 83 0B                 sta   ThePtr+2,s
0796 BE4D 80 F0                 bra   @Strip
0797 BE4F
0798 BE4F
0799 BE4F              GetResourceHandle  
0800 BE4F 48                    pha   
0801 BE50 48                    pha   
0802 BE51 F4 0B 80              PushWord #rTextForLETextBox2   ; type
0803 BE54 DA                    phx   
0804 BE55 48                    pha   
0805 BE56 20 9C 9D              jsr   LoadResource
0806 BE59
0807 BE59 68                    pla   
0808 BE5A FA                    plx   
0809 BE5B 60                    rts   
0810 BE5C
0811 BE5C
0812 BE5C                       ENDP 
0813 BE5C
0814 BE5C                       title 'StatTextProc -- Utils' 
0815 BE5C              ****************************************************************
0816 BE5C              *
0817 BE5C              UsefulUtils PROC 
0818 BE5C              *
0819 BE5C              * Description
0820 BE5C              *
0821 BE5C              *
0822 BE5C              * Inputs:
0823 BE5C              *                   none
0824 BE5C              *
0825 BE5C              * Outputs:
0826 BE5C              *                   none
0827 BE5C              *
0828 BE5C              * External Refs:
0829 BE5C              *                   none
0830 BE5C              *
0831 BE5C              * Entry Points:
0832 BE5C              *
0833 BE5C                       longa on                       ; mode
0834 BE5C                       longi on
0835 BE5C              *
0836 BE5C              ****************************************************************
0837 BE5C
0838 BE5C
0839 BE5C
0840 BE5C              ;-----------------------------------------------------------
0841 BE5C              ;
0842 BE5C              ; Returns the value in ctlData in A and X registers.
0843 BE5C              ;
0844 BE5C                       ENTRY CtlDataToAX 
0845 BE5C              CtlDataToAX  
0846 BE5C A0 1E 00              ldy   #NewCtlRecord.ctlData+2
0847 BE5F B7 04                 lda   [ctlPtr],y
0848 BE61 AA                    tax   
0849 BE62 88                    dey   
0850 BE63 88                    dey   
0851 BE64 B7 04                 lda   [ctlPtr],y
0852 BE66 60                    rts   
0853 BE67
0854 BE67
0855 BE67              ;-----------------------------------------------------------
0856 BE67              ;
0857 BE67              ; Returns the text Ref verb in a-reg.
0858 BE67              ;
0859 BE67                       Import GetRefType 
0860 BE67              GetRefType PROC EXPORT 
0861 BE67 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
0862 BE6A B7 04                 lda   [ctlPtr],y
0863 BE6C 29 03 00              and   #$0003
0864 BE6F 60                    rts   
0865 BE70
0866 BE70                       ENDP 
0867 BE70
0868 BE70                       END   
